--> pralable
-- USE DB_SQL;

SELECT s.name AS TABLE_SCHEMA,
       o.name AS TABLE_NAME,
       i.name AS INDEX_NAME,
       p.partition_number AS PART_NUMBER,
       rows AS NB_ROWS
FROM   sys.partitions AS p
       INNER JOIN sys.indexes AS i
             ON p.object_id = i.object_id
                AND p.index_id = i.index_id
       INNER JOIN sys.partition_schemes ps
             ON i.data_space_id=ps.data_space_id
       INNER JOIN sys.objects AS o
             ON o.object_id = i.object_id
       INNER JOIN sys.schemas AS s
             ON o.schema_id = s.schema_id
ORDER BY TABLE_SCHEMA, TABLE_NAME, INDEX_NAME;